/////////////////////////////////////////
//        KEY FUNCTIONS                //
/////////////////////////////////////////


void keyPressed() 
{
  if (key == 's' || key == 'S') 
  {
    PGraphics pdf = createGraphics(img.width, img.height, PDF, "output.pdf");
    pdf.beginDraw();
    pdf.noStroke();   
    pdf.image(img, 0, 0);
    
    LinkedHashSet<PVector> pointsDisplay = new LinkedHashSet<PVector>();   
    pointsDisplay = (LinkedHashSet)points.clone(); 
    triangles = Triangulate.triangulate(pointsDisplay);
    
    for (int i = 0; i < triangles.size(); i++) 
    {
      Triangle t = (Triangle)triangles.get(i);

      int ave_x = int((t.p1.x + t.p2.x + t.p3.x)/3);  
      int ave_y = int((t.p1.y + t.p2.y + t.p3.y)/3);

      pdf.fill( img_b.get(ave_x, ave_y));

      pdf.triangle(t.p1.x, t.p1.y, t.p2.x, t.p2.y, t.p3.x, t.p3.y);
    }
    pdf.dispose();
    pdf.endDraw();
    save("output.png");
  }

  if (key == 'o' || key == 'O') 
  {
    displayType = "image";
    r.activate(0);
  }

  if (key == 'r' || key == 'R') 
  {
    displayType = "result";
    r.activate(4);
  }

  if (key == 'b' || key == 'B') 
  {
    displayType = "blurred";
    r.activate(1);
  }

  if (key == 'm' || key == 'M') 
  {
    displayType = "mesh";
    r.activate(2);
  }
 
  if (key == 'c' || key == 'C') 
  {
    displayType = "contour";
    r.activate(3);
  }

  if (key == 'e' || key == 'E') 
  {
    if (deleteMode == true) 
    {
      e.setState(false);
    }
    else if (deleteMode == false) 
    {  
      e.setState(true);
    }
  }
   if ((key == '}' || key == ']') && (eraserSize != maxEraserSize))
  {
    eraserSize = eraserSize+1;  
  }
  
  if ((key == '{' || key == '[') && (eraserSize != minEraserSize))
  {
    eraserSize = eraserSize-1;
  }
  
  //println(keyCode);
  //println(key);
}
