/////////////////////////////////////////
//        BUTTON FUNCTIONS             //
/////////////////////////////////////////

public void eraser(boolean theFlag) 
{
  //println("delete flag set");
  if (theFlag==true) 
  {
    deleteMode = true;
    refreshBufferOnce = true;
    pointsDisplay = (LinkedHashSet)points.clone();  
  } 
  else 
  {
    cursor(CROSS);
    deleteMode = false;
    refreshBuffer = true;
    refreshBufferOnce = false;
  }
}

public void choose() 
{
  refreshBuffer = true;
  selectInput("Select a file to process:", "imageFileSelect");
} //end choose

public void lPoints() 
{
  refreshBuffer = true;
  selectInput("Select a points text file:", "pointsFileSelect");
} //end lPoints

public void sPoints() 
{
  selectOutput("Save points text file:", "pointsFileSave");
} //end sPoints

public void savePDF()
{
  selectOutput("Save as a pdf:", "pdfFileSave");
}

public void saveOBJ()
{
  selectOutput("Save as a obj:", "objFileSave");
}

public void contWeight (int _value) 
{
  if (deleteMode == true){refreshBuffer = true;}
  img_c = countourImage(img_b, _value, (int)cThSlider.getValue());
  contourImgPoints = getThresholdPixels (img_c, true);
  nonContourPoints = contourImgPoints.get(0);
  contourPoints = contourImgPoints.get(1);
  displayType = "contour";
  r.activate(3);
}

public void contThreshold (int _value) 
{
  if (deleteMode == true){refreshBuffer = true;}
  img_c = countourImage(img_b, (int)cWSlider.getValue(),_value);
  contourImgPoints = getThresholdPixels (img_c, true);
  nonContourPoints = contourImgPoints.get(0);
  contourPoints = contourImgPoints.get(1);
  displayType = "contour";  
  r.activate(3);
}

public void blur (int blur_value) 
{
  smartFilter.setRadius(int(blur_value)); 
  //println("a numberbox event. setting background to "+ blur_value);
}

public void threshold (float threshold_value) 
{
  smartFilter.setThreshold((threshold_value)); 
  //println("a numberbox event. setting background to "+ threshold_value);
}

public void blurIt () 
{
  if ( smartFilter.getRadius() != 0 && smartFilter.getThreshold() != 0)
  {
    noLoop();
    displayBlurMessage = true;
    redraw();
    
    BufferedImage filtered = smartFilter.filter((BufferedImage) img.getNative());
    img_b = new PImage(filtered);
    loop();
    displayBlurMessage = false;
  }
  else
  {
    img_b = img.get();
  }
  displayType = "blurred";
  r.activate(1);
}

public void passChooser(int a) 
{ 
  if (a == 1)
  {
    displayType = "image";
    r.activate(0);
  }  

  if (a==2)
  {
    displayType = "blurred";
    r.activate(1);
  }

  if (a==3)
  {
    refreshBuffer = true;
    displayType = "mesh";
    r.activate(2);
  }

  if (a==4)
  {
    refreshBuffer = true;
    displayType = "result";
    r.activate(4);
  }
  if (a==5)
  {
    displayType = "contour";
    r.activate(3);
  }
}

//need to resolve this - currently uses the old pvector list need to convert everything to hashset
public void randomPointsN(int pointsNumber)
{
  //noLoop();
  if (deleteMode == true){refreshBuffer = true;}
  LinkedHashSet<PVector> contourPointsHash = new LinkedHashSet<PVector>(sublistIntList(contourPoints, 0, (int)cPSlider.getValue()));
  LinkedHashSet<PVector> nonContourPointsHash = new LinkedHashSet<PVector>(sublistIntList(nonContourPoints, 0, pointsNumber));   
  points = new LinkedHashSet<PVector>();
  pointsDisplay = new LinkedHashSet<PVector>();
  points.addAll(userPointsHash);
  points.addAll(contourPointsHash);
  points.addAll(nonContourPointsHash);
  
  pointsDisplay.addAll(points);

  //println(userPointsHash);
  //loop();
}

public void contourPointsN(int pointsNumber)
{
  //noLoop();
  if (deleteMode == true){refreshBuffer = true;}
  LinkedHashSet<PVector> contourPointsHash = new LinkedHashSet<PVector>(sublistIntList(contourPoints, 0, pointsNumber));
  LinkedHashSet<PVector> nonContourPointsHash = new LinkedHashSet<PVector>(sublistIntList(nonContourPoints, 0, (int)nCPSlider.getValue()));   
  points = new LinkedHashSet<PVector>();
  pointsDisplay = new LinkedHashSet<PVector>();
  points.addAll(userPointsHash);
  points.addAll(contourPointsHash);
  points.addAll(nonContourPointsHash);
  
  pointsDisplay.addAll(points);
  //loop();
}
