/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Button;
import controlP5.ControlP5;
import controlP5.ControllerGroup;
import controlP5.Group;
import controlP5.RadioButton;
import controlP5.Slider;
import controlP5.Textarea;
import controlP5.Toggle;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PVector;
import processing.data.IntList;
import processing.event.MouseEvent;

public class TriangulateImage7_2_3_2_1
extends PApplet {
    public int blur_val = 0;
    public String displayType = "mesh";
    public boolean deleteMode = false;
    public boolean panMode = false;
    boolean refreshBuffer = true;
    boolean refreshBufferOnce = false;
    public SmartBlurFilter smartFilter = new SmartBlurFilter();
    boolean insideFrame;
    int maxEraserSize = 80;
    int minEraserSize = 1;
    boolean displayBlurMessage = false;
    float eraserSize = 5.0f;
    PImage img;
    PImage img_b;
    PImage img_c;
    PImage delCursor;
    PImage processingTextImg;
    private ControlP5 cp5;
    ControlFrame cf;
    RadioButton r;
    Toggle e;
    Textarea ta;
    Slider blurSlider;
    Slider thSlider;
    Slider nCPSlider;
    Slider cPSlider;
    Slider cWSlider;
    Slider cThSlider;
    Slider TransSlider;
    Button chooseButton;
    Button blurButton;
    Button sPButton;
    Button lPButton;
    int controlFrameWidth = 360;
    int initWindowLocationX = 100;
    int initWindowLocationY = 100;
    float mx;
    float my;
    float ratio;
    float xpt;
    float ypt;
    float xzt;
    float yzt;
    float swt;
    float zoom;
    float mappedMouseX;
    float mappedMouseY;
    PrintWriter output;
    PGraphics pdf;
    ArrayList<PVector> contourPointsList = new ArrayList();
    ArrayList<IntList> contourImgPoints;
    ArrayList triangles = new ArrayList();
    LinkedHashSet<PVector> userPointsHash = new LinkedHashSet();
    LinkedHashSet<PVector> points = new LinkedHashSet();
    LinkedHashSet<PVector> pointsDisplay = new LinkedHashSet();
    IntList contourPoints = new IntList();
    IntList nonContourPoints = new IntList();

    public void setup() {
        this.zoom = 1.0f;
        this.img = this.loadImage("Instructions.png");
        this.processingTextImg = this.loadImage("processing.png");
        this.img_b = this.img.get();
        this.img_c = this.countourImage(this.img_b, 1, 80);
        this.surface.setSize(this.img.width, this.img.height);
        this.surface.setResizable(true);
        this.surface.setTitle("Traingulate 7");
        this.surface.setLocation(this.initWindowLocationX + this.controlFrameWidth, this.initWindowLocationY);
        this.points.add(new PVector(0.0f, 0.0f, 0.0f));
        this.points.add(new PVector((float)(this.img.width - 1), 0.0f, 0.0f));
        this.points.add(new PVector((float)(this.img.width - 1), (float)(this.img.height - 1), 0.0f));
        this.points.add(new PVector(0.0f, (float)(this.img.height - 1), 0.0f));
        this.points.add(new PVector((float)(this.img.width / 2), (float)(this.img.height / 2), 0.0f));
        this.userPointsHash.addAll(this.points);
        this.pointsDisplay.addAll(this.points);
        this.contourImgPoints = this.getThresholdPixels(this.img_c, true);
        this.nonContourPoints = this.contourImgPoints.get(0);
        this.contourPoints = this.contourImgPoints.get(1);
        this.noStroke();
        this.frameRate(60.0f);
        this.cursor(1);
        this.cp5 = new ControlP5((PApplet)this);
        this.cf = new ControlFrame(this, 340, 690, "Tools");
    }

    public void draw() {
        this.scale(this.zoom);
        this.translate(this.xpt - this.xzt, this.ypt - this.yzt);
        this.background(128);
        switch (this.displayType) {
            case "image": {
                this.image(this.img, 0.0f, 0.0f);
                this.noStroke();
                this.fill(0.0f, 0.0f, 255.0f);
                for (PVector temp : this.pointsDisplay) {
                    this.ellipse(temp.x, temp.y, 2.0f, 2.0f);
                }
                if (!this.displayBlurMessage) break;
                this.drawBlurMessage();
                break;
            }
            case "blurred": {
                this.image(this.img_b, 0.0f, 0.0f);
                this.noStroke();
                this.fill(0.0f, 0.0f, 255.0f);
                for (PVector temp : this.pointsDisplay) {
                    this.ellipse(temp.x, temp.y, 2.0f, 2.0f);
                }
                if (!this.displayBlurMessage) break;
                this.drawBlurMessage();
                break;
            }
            case "contour": {
                this.image(this.img_c, 0.0f, 0.0f);
                this.noStroke();
                this.fill(255.0f, 0.0f, 0.0f);
                for (PVector temp : this.pointsDisplay) {
                    this.ellipse(temp.x, temp.y, 2.0f, 2.0f);
                }
                if (!this.displayBlurMessage) break;
                this.drawBlurMessage();
                break;
            }
            case "mesh": {
                this.image(this.img, 0.0f, 0.0f);
                if (this.refreshBuffer) {
                    this.triangles = Triangulate.triangulate(this.pointsDisplay);
                }
                this.noFill();
                this.beginShape(9);
                this.strokeJoin(32);
                this.strokeWeight(0.7f / this.zoom);
                this.stroke(0.0f, 0.0f, 255.0f);
                int i = 0;
                while (i < this.triangles.size()) {
                    Triangle t = (Triangle)this.triangles.get(i);
                    this.vertex(t.p1.x, t.p1.y);
                    this.vertex(t.p2.x, t.p2.y);
                    this.vertex(t.p3.x, t.p3.y);
                    ++i;
                }
                this.endShape();
                if (this.refreshBufferOnce) {
                    this.refreshBuffer = false;
                }
                if (!this.displayBlurMessage) break;
                this.drawBlurMessage();
                break;
            }
            case "result": {
                this.image(this.img_b, 0.0f, 0.0f);
                this.noStroke();
                if (this.refreshBuffer) {
                    this.triangles = Triangulate.triangulate(this.pointsDisplay);
                }
                this.beginShape(9);
                int i = 0;
                while (i < this.triangles.size()) {
                    int ave_y;
                    Triangle t = (Triangle)this.triangles.get(i);
                    int ave_x = PApplet.parseInt((float)((t.p1.x + t.p2.x + t.p3.x) / 3.0f));
                    if (this.notInsideImage(ave_x, ave_y = PApplet.parseInt((float)((t.p1.y + t.p2.y + t.p3.y) / 3.0f)))) {
                        PVector imgEdgeIntersection = this.lineIntersectionBox(new PVector((float)ave_x, (float)ave_y), new PVector((float)(this.img.width / 2), (float)(this.img.height / 2)), new PVector(1.0f, 1.0f), new PVector((float)(this.img.width - 1), (float)(this.img.height - 1)));
                        this.fill(this.img_b.get(TriangulateImage7_2_3_2_1.floor((float)imgEdgeIntersection.x), TriangulateImage7_2_3_2_1.floor((float)imgEdgeIntersection.y)), 255.0f);
                    } else {
                        this.fill(this.img_b.get(ave_x, ave_y), 255.0f);
                    }
                    this.vertex(t.p1.x, t.p1.y);
                    this.vertex(t.p2.x, t.p2.y);
                    this.vertex(t.p3.x, t.p3.y);
                    ++i;
                }
                this.endShape();
                if (this.refreshBufferOnce) {
                    this.refreshBuffer = false;
                }
                if (!this.displayBlurMessage) break;
                this.drawBlurMessage();
                break;
            }
            default: {
                this.image(this.img, 0.0f, 0.0f);
                this.noStroke();
                if (!this.displayBlurMessage) break;
                this.drawBlurMessage();
            }
        }
        if (this.deleteMode) {
            this.drawEraserCursor();
            this.refreshBuffer = false;
        }
    }

    public PImage countourImage(PImage img, int v, int threshold) {
        int w = v * -8;
        int[][] kernel = new int[][]{{v, v, v}, {v, w, v}, {v, v, v}};
        PImage edgeImg = this.createImage(img.width, img.height, 1);
        int y = 1;
        while (y < img.height - 1) {
            int x = 1;
            while (x < img.width - 1) {
                float sum = 0.0f;
                int ky = -1;
                while (ky <= 1) {
                    int kx = -1;
                    while (kx <= 1) {
                        int pos = (y + ky) * img.width + (x + kx);
                        float val = this.red(img.pixels[pos]);
                        sum += (float)kernel[ky + 1][kx + 1] * val;
                        ++kx;
                    }
                    ++ky;
                }
                sum = sum >= (float)threshold ? 255.0f : 0.0f;
                edgeImg.pixels[y * img.width + x] = this.color(sum);
                ++x;
            }
            ++y;
        }
        edgeImg.updatePixels();
        return edgeImg;
    }

    public ArrayList<IntList> getThresholdPixels(PImage inImg, boolean shuffled) {
        ArrayList<IntList> result = new ArrayList<IntList>();
        IntList cP = new IntList();
        IntList nCP = new IntList();
        int y = 0;
        while (y < inImg.height) {
            int x = 0;
            while (x < inImg.width) {
                int i;
                int argb = inImg.get(x, y);
                int value = argb >> 16 & 0xFF;
                if (value > 254 || x == 0 || y == 0 || x == inImg.width - 1 || y == inImg.height - 1) {
                    i = y * inImg.width + x;
                    cP.append(i);
                } else {
                    i = y * inImg.width + x;
                    nCP.append(i);
                }
                ++x;
            }
            ++y;
        }
        if (shuffled) {
            cP.shuffle();
            nCP.shuffle();
        }
        result.add(nCP);
        result.add(cP);
        return result;
    }

    public int[] shuffle(int[] array) {
        int m = array.length;
        while (m < 0) {
            int i = (int)Math.floor(Math.random() * (double)m--);
            int t = array[m];
            array[m] = array[i];
            array[i] = t;
        }
        return array;
    }

    public LinkedHashSet<PVector> sublistIntList(IntList inList, int start, int end) {
        LinkedHashSet<PVector> result = new LinkedHashSet<PVector>();
        int i = start;
        while (i < end) {
            result.add(this.intToCoords(inList.get(i)));
            ++i;
        }
        return result;
    }

    public PVector intToCoords(int tempPoint) {
        int tempX = tempPoint % this.img.width;
        int tempY = tempPoint / this.img.width;
        PVector result = new PVector((float)tempX, (float)tempY, 0.0f);
        return result;
    }

    public boolean notInsideImage(float _x, float _y) {
        return _x <= 0.0f || _x >= (float)this.img.width || _y <= 0.0f || _y >= (float)this.img.height;
    }

    public PVector lineIntersection(PVector p1, PVector p2, PVector p3, PVector p4) {
        PVector b = PVector.sub((PVector)p2, (PVector)p1);
        PVector d = PVector.sub((PVector)p4, (PVector)p3);
        float b_dot_d_perp = b.x * d.y - b.y * d.x;
        if (b_dot_d_perp == 0.0f) {
            return null;
        }
        PVector c = PVector.sub((PVector)p3, (PVector)p1);
        float t = (c.x * d.y - c.y * d.x) / b_dot_d_perp;
        if (t < 0.0f || t > 1.0f) {
            return null;
        }
        float u = (c.x * b.y - c.y * b.x) / b_dot_d_perp;
        if (u < 0.0f || u > 1.0f) {
            return null;
        }
        return new PVector(p1.x + t * b.x, p1.y + t * b.y);
    }

    public PVector lineIntersectionBox(PVector p1, PVector p2, PVector boxP1, PVector boxP2) {
        PVector result = null;
        PVector[] boxVectors = new PVector[]{new PVector(boxP1.x, boxP1.y), new PVector(boxP1.x, boxP2.y), new PVector(boxP1.x, boxP2.y), new PVector(boxP2.x, boxP2.y), new PVector(boxP2.x, boxP2.y), new PVector(boxP2.x, boxP1.y), new PVector(boxP2.x, boxP1.y), new PVector(boxP1.x, boxP1.y)};
        int i = 0;
        while (i < boxVectors.length) {
            PVector is = this.lineIntersection(p1, p2, boxVectors[i], boxVectors[i + 1]);
            if (is != null) {
                result = is;
                break;
            }
            i += 2;
        }
        return result;
    }

    public void eraser(boolean theFlag) {
        if (theFlag) {
            this.deleteMode = true;
            this.refreshBufferOnce = true;
            this.pointsDisplay = (LinkedHashSet)this.points.clone();
        } else {
            this.cursor(1);
            this.deleteMode = false;
            this.refreshBuffer = true;
            this.refreshBufferOnce = false;
        }
    }

    public void choose() {
        this.refreshBuffer = true;
        this.selectInput("Select a file to process:", "imageFileSelect");
    }

    public void lPoints() {
        this.refreshBuffer = true;
        this.selectInput("Select a points text file:", "pointsFileSelect");
    }

    public void sPoints() {
        this.selectOutput("Save points text file:", "pointsFileSave");
    }

    public void savePDF() {
        this.selectOutput("Save as a pdf:", "pdfFileSave");
    }

    public void saveOBJ() {
        this.selectOutput("Save as a obj:", "objFileSave");
    }

    public void contWeight(int _value) {
        if (this.deleteMode) {
            this.refreshBuffer = true;
        }
        this.img_c = this.countourImage(this.img_b, _value, (int)this.cThSlider.getValue());
        this.contourImgPoints = this.getThresholdPixels(this.img_c, true);
        this.nonContourPoints = this.contourImgPoints.get(0);
        this.contourPoints = this.contourImgPoints.get(1);
        this.displayType = "contour";
        this.r.activate(3);
    }

    public void contThreshold(int _value) {
        if (this.deleteMode) {
            this.refreshBuffer = true;
        }
        this.img_c = this.countourImage(this.img_b, (int)this.cWSlider.getValue(), _value);
        this.contourImgPoints = this.getThresholdPixels(this.img_c, true);
        this.nonContourPoints = this.contourImgPoints.get(0);
        this.contourPoints = this.contourImgPoints.get(1);
        this.displayType = "contour";
        this.r.activate(3);
    }

    public void blur(int blur_value) {
        this.smartFilter.setRadius(PApplet.parseInt((float)blur_value));
    }

    public void threshold(float threshold_value) {
        this.smartFilter.setThreshold(threshold_value);
    }

    public void blurIt() {
        if (this.smartFilter.getRadius() != 0 && this.smartFilter.getThreshold() != 0.0) {
            this.noLoop();
            this.displayBlurMessage = true;
            this.redraw();
            BufferedImage filtered = this.smartFilter.filter((BufferedImage)this.img.getNative());
            this.img_b = new PImage((Image)filtered);
            this.loop();
            this.displayBlurMessage = false;
        } else {
            this.img_b = this.img.get();
        }
        this.displayType = "blurred";
        this.r.activate(1);
    }

    public void passChooser(int a) {
        if (a == 1) {
            this.displayType = "image";
            this.r.activate(0);
        }
        if (a == 2) {
            this.displayType = "blurred";
            this.r.activate(1);
        }
        if (a == 3) {
            this.refreshBuffer = true;
            this.displayType = "mesh";
            this.r.activate(2);
        }
        if (a == 4) {
            this.refreshBuffer = true;
            this.displayType = "result";
            this.r.activate(4);
        }
        if (a == 5) {
            this.displayType = "contour";
            this.r.activate(3);
        }
    }

    public void randomPointsN(int pointsNumber) {
        if (this.deleteMode) {
            this.refreshBuffer = true;
        }
        LinkedHashSet<PVector> contourPointsHash = new LinkedHashSet<PVector>(this.sublistIntList(this.contourPoints, 0, (int)this.cPSlider.getValue()));
        LinkedHashSet<PVector> nonContourPointsHash = new LinkedHashSet<PVector>(this.sublistIntList(this.nonContourPoints, 0, pointsNumber));
        this.points = new LinkedHashSet();
        this.pointsDisplay = new LinkedHashSet();
        this.points.addAll(this.userPointsHash);
        this.points.addAll(contourPointsHash);
        this.points.addAll(nonContourPointsHash);
        this.pointsDisplay.addAll(this.points);
    }

    public void contourPointsN(int pointsNumber) {
        if (this.deleteMode) {
            this.refreshBuffer = true;
        }
        LinkedHashSet<PVector> contourPointsHash = new LinkedHashSet<PVector>(this.sublistIntList(this.contourPoints, 0, pointsNumber));
        LinkedHashSet<PVector> nonContourPointsHash = new LinkedHashSet<PVector>(this.sublistIntList(this.nonContourPoints, 0, (int)this.nCPSlider.getValue()));
        this.points = new LinkedHashSet();
        this.pointsDisplay = new LinkedHashSet();
        this.points.addAll(this.userPointsHash);
        this.points.addAll(contourPointsHash);
        this.points.addAll(nonContourPointsHash);
        this.pointsDisplay.addAll(this.points);
    }

    public void drawEraserCursor() {
        this.noFill();
        this.stroke(0);
        this.strokeWeight(2.0f / this.zoom);
        this.ellipse(this.mappedMouseX, this.mappedMouseY, this.eraserSize * 2.0f, this.eraserSize * 2.0f);
    }

    public void drawBlurMessage() {
        int img_w = 297;
        int img_h = 40;
        int img_x = (this.img.width - img_w) / 2;
        int img_y = (this.img.height - img_h) / 2;
        this.fill(0.0f, 0.0f, 255.0f);
        this.rect(0.0f, this.img.height / 2 - 30, this.img.width, 60.0f);
        this.textAlign(3, 3);
        this.textSize(40.0f);
        this.fill(255);
        this.image(this.processingTextImg, img_x, img_y, img_w, img_h);
    }

    public void keyPressed() {
        if (this.key == 's' || this.key == 'S') {
            PGraphics pdf = this.createGraphics(this.img.width, this.img.height, "processing.pdf.PGraphicsPDF", "output.pdf");
            pdf.beginDraw();
            pdf.noStroke();
            pdf.image(this.img, 0.0f, 0.0f);
            LinkedHashSet pointsDisplay = new LinkedHashSet();
            pointsDisplay = (LinkedHashSet)this.points.clone();
            this.triangles = Triangulate.triangulate(pointsDisplay);
            int i = 0;
            while (i < this.triangles.size()) {
                Triangle t = (Triangle)this.triangles.get(i);
                int ave_x = PApplet.parseInt((float)((t.p1.x + t.p2.x + t.p3.x) / 3.0f));
                int ave_y = PApplet.parseInt((float)((t.p1.y + t.p2.y + t.p3.y) / 3.0f));
                pdf.fill(this.img_b.get(ave_x, ave_y));
                pdf.triangle(t.p1.x, t.p1.y, t.p2.x, t.p2.y, t.p3.x, t.p3.y);
                ++i;
            }
            pdf.dispose();
            pdf.endDraw();
            this.save("output.png");
        }
        if (this.key == 'o' || this.key == 'O') {
            this.displayType = "image";
            this.r.activate(0);
        }
        if (this.key == 'r' || this.key == 'R') {
            this.displayType = "result";
            this.r.activate(4);
        }
        if (this.key == 'b' || this.key == 'B') {
            this.displayType = "blurred";
            this.r.activate(1);
        }
        if (this.key == 'm' || this.key == 'M') {
            this.displayType = "mesh";
            this.r.activate(2);
        }
        if (this.key == 'c' || this.key == 'C') {
            this.displayType = "contour";
            this.r.activate(3);
        }
        if (this.key == 'e' || this.key == 'E') {
            if (this.deleteMode) {
                this.e.setState(false);
            } else if (!this.deleteMode) {
                this.e.setState(true);
            }
        }
        if ((this.key == '}' || this.key == ']') && this.eraserSize != (float)this.maxEraserSize) {
            this.eraserSize += 1.0f;
        }
        if ((this.key == '{' || this.key == '[') && this.eraserSize != (float)this.minEraserSize) {
            this.eraserSize -= 1.0f;
        }
    }

    public void pdfFileSave(File selection) {
        if (selection == null) {
            this.ta.setColor(this.color(255));
            this.ta.setText("Status.\nNothing selected, no file saved.");
        } else {
            this.pdf = selection.getName().endsWith(".pdf") ? this.createGraphics(this.img.width, this.img.height, "processing.pdf.PGraphicsPDF", selection.getAbsolutePath()) : this.createGraphics(this.img.width, this.img.height, "processing.pdf.PGraphicsPDF", String.valueOf(selection.getAbsolutePath()) + ".pdf");
            this.pdf.beginDraw();
            this.pdf.noStroke();
            this.pdf.image(this.img, 0.0f, 0.0f);
            LinkedHashSet pointsDisplay = new LinkedHashSet();
            pointsDisplay = (LinkedHashSet)this.points.clone();
            this.triangles = Triangulate.triangulate(pointsDisplay);
            int i = 0;
            while (i < this.triangles.size()) {
                Triangle t = (Triangle)this.triangles.get(i);
                int ave_x = PApplet.parseInt((float)((t.p1.x + t.p2.x + t.p3.x) / 3.0f));
                int ave_y = PApplet.parseInt((float)((t.p1.y + t.p2.y + t.p3.y) / 3.0f));
                this.pdf.fill(this.img_b.get(ave_x, ave_y));
                this.pdf.triangle(t.p1.x, t.p1.y, t.p2.x, t.p2.y, t.p3.x, t.p3.y);
                ++i;
            }
            this.pdf.dispose();
            this.pdf.endDraw();
            this.ta.setColor(this.color(0, 255, 0));
            this.ta.setText("Success.\nThe File was Saved Successfully!");
        }
    }

    public void objFileSave(File selection) {
        if (selection == null) {
            this.ta.setColor(this.color(255));
            this.ta.setText("Status.\nNothing selected, no file saved.");
        } else {
            String mtlFileName;
            PrintWriter outputMTL;
            PrintWriter outputOBJ;
            if (selection.getName().endsWith(".obj")) {
                outputOBJ = this.createWriter(selection.getAbsolutePath());
                outputMTL = this.createWriter(selection.getAbsolutePath().replace(".obj", ".mtl"));
                mtlFileName = selection.getName().replace(".obj", ".mtl");
            } else {
                outputOBJ = this.createWriter(String.valueOf(selection.getAbsolutePath()) + ".obj");
                outputMTL = this.createWriter(String.valueOf(selection.getAbsolutePath()) + ".mtl");
                mtlFileName = String.valueOf(selection.getName()) + ".mtl";
            }
            outputOBJ.println("mtllib " + mtlFileName + "\n");
            LinkedHashSet pointsDisplay = new LinkedHashSet();
            pointsDisplay = (LinkedHashSet)this.points.clone();
            this.triangles = Triangulate.triangulate(pointsDisplay);
            LinkedHashSet<Integer> colorHash = new LinkedHashSet<Integer>();
            int i = 0;
            while (i < this.triangles.size()) {
                Triangle t = (Triangle)this.triangles.get(i);
                int ave_x = PApplet.parseInt((float)((t.p1.x + t.p2.x + t.p3.x) / 3.0f));
                int ave_y = PApplet.parseInt((float)((t.p1.y + t.p2.y + t.p3.y) / 3.0f));
                int img_bColor = this.img_b.get(ave_x, ave_y);
                String colorRGBName = String.valueOf(TriangulateImage7_2_3_2_1.str((int)(img_bColor >> 16 & 0xFF))) + "_" + TriangulateImage7_2_3_2_1.str((int)(img_bColor >> 8 & 0xFF)) + "_" + TriangulateImage7_2_3_2_1.str((int)(img_bColor & 0xFF));
                boolean hasColor = colorHash.contains(img_bColor);
                if (!hasColor) {
                    colorHash.add(img_bColor);
                    String img_b_r = TriangulateImage7_2_3_2_1.str((float)((float)(img_bColor >> 16 & 0xFF) / 255.0f));
                    String img_b_g = TriangulateImage7_2_3_2_1.str((float)((float)(img_bColor >> 8 & 0xFF) / 255.0f));
                    String img_b_b = TriangulateImage7_2_3_2_1.str((float)((float)(img_bColor & 0xFF) / 255.0f));
                    outputMTL.println("newmtl Colour_" + colorRGBName);
                    outputMTL.println("\tNs 32");
                    outputMTL.println("\td 1");
                    outputMTL.println("\tTr 0");
                    outputMTL.println("\tTf 1 1 1");
                    outputMTL.println("\tillum 2");
                    outputMTL.println("\tKa " + img_b_r + " " + img_b_g + " " + img_b_b);
                    outputMTL.println("\tKd " + img_b_r + " " + img_b_g + " " + img_b_b);
                    outputMTL.println("\tKs 0.349999994 0.349999994 0.349999994\n");
                }
                outputOBJ.println("v " + TriangulateImage7_2_3_2_1.str((float)t.p1.x) + " " + TriangulateImage7_2_3_2_1.str((float)t.p1.y) + " 0");
                outputOBJ.println("v " + TriangulateImage7_2_3_2_1.str((float)t.p2.x) + " " + TriangulateImage7_2_3_2_1.str((float)t.p2.y) + " 0");
                outputOBJ.println("v " + TriangulateImage7_2_3_2_1.str((float)t.p3.x) + " " + TriangulateImage7_2_3_2_1.str((float)t.p3.y) + " 0");
                outputOBJ.println("vn 0 1 0");
                outputOBJ.println("g triangle_" + TriangulateImage7_2_3_2_1.str((int)i));
                outputOBJ.println("usemtl Colour_" + colorRGBName);
                outputOBJ.println("s 1");
                outputOBJ.println("f " + TriangulateImage7_2_3_2_1.str((int)(i * 3 + 1)) + "//" + TriangulateImage7_2_3_2_1.str((int)(i + 1)) + " " + TriangulateImage7_2_3_2_1.str((int)(i * 3 + 2)) + "//" + TriangulateImage7_2_3_2_1.str((int)(i + 1)) + " " + TriangulateImage7_2_3_2_1.str((int)(i * 3 + 3)) + "//" + TriangulateImage7_2_3_2_1.str((int)(i + 1)) + "\n");
                ++i;
            }
            outputOBJ.flush();
            outputOBJ.close();
            outputMTL.flush();
            outputMTL.close();
            this.ta.setColor(this.color(0, 255, 0));
            this.ta.setText("Success.\nThe File was Saved Successfully!");
        }
    }

    public void pointsFileSelect(File selection) {
        if (selection != null) {
            if (selection.getName().endsWith("txt")) {
                String[] lines = this.loadStrings(selection.getPath());
                String[] width_height = TriangulateImage7_2_3_2_1.split((String)lines[0], (String)" ");
                if (TriangulateImage7_2_3_2_1.parseFloat((String)width_height[0]) == (float)this.img.width && TriangulateImage7_2_3_2_1.parseFloat((String)width_height[1]) == (float)this.img.height) {
                    this.zoom = 1.0f;
                    this.xpt = 0.0f;
                    this.ypt = 0.0f;
                    this.xzt = 0.0f;
                    this.yzt = 0.0f;
                    this.noLoop();
                    this.points = new LinkedHashSet();
                    this.userPointsHash = new LinkedHashSet();
                    int i = 1;
                    while (i < lines.length) {
                        String[] coords = TriangulateImage7_2_3_2_1.split((String)lines[i], (String)", ");
                        String[] coords_x = TriangulateImage7_2_3_2_1.split((String)coords[0], (String)"[ ");
                        float x_ = TriangulateImage7_2_3_2_1.parseFloat((String)coords_x[1]);
                        float y_ = TriangulateImage7_2_3_2_1.parseFloat((String)coords[1]);
                        this.points.add(new PVector(x_, y_, 0.0f));
                        this.userPointsHash.add(new PVector(x_, y_, 0.0f));
                        ++i;
                    }
                    this.loop();
                    this.ta.setColor(this.color(0, 255, 0));
                    this.ta.setText("Success.\nPoints are loaded.");
                    this.nCPSlider.setValue(0.0f);
                    this.cPSlider.setValue(0.0f);
                } else {
                    this.ta.setColor(this.color(255, 0, 0));
                    this.ta.setText("Error.\nPoints file does not match the loaded image.");
                }
            } else {
                this.ta.setColor(this.color(255, 0, 0));
                this.ta.setText("Error.\nPlease choose a txt file.");
            }
        }
    }

    public void imageFileSelect(File selection) {
        if (selection == null) {
            this.ta.setColor(this.color(255));
            this.ta.setText("Status.\nNothing selected, selection was cancelled.");
        } else if (selection.getName().endsWith("jpg") || selection.getName().endsWith("JPEG") || selection.getName().endsWith("JPG") || selection.getName().endsWith("jpeg") || selection.getName().endsWith("png") || selection.getName().endsWith("PNG") || selection.getName().endsWith("GIF") || selection.getName().endsWith("gif") || selection.getName().endsWith("tga") || selection.getName().endsWith("TGA") || selection.getName().endsWith("tiff") || selection.getName().endsWith("TIFF") || selection.getName().endsWith("tif") || selection.getName().endsWith("TIF")) {
            PImage checkImg = this.loadImage(selection.getAbsolutePath());
            if (checkImg != null && checkImg.width > 0 && checkImg.height > 0) {
                int p;
                this.img = checkImg.get();
                String Scaled = "";
                int q = selection.getAbsolutePath().lastIndexOf(46);
                if (q > (p = Math.max(selection.getAbsolutePath().lastIndexOf(47), selection.getAbsolutePath().lastIndexOf(92)))) {
                    selection.getAbsolutePath().substring(q + 1);
                }
                if (this.img.width + 60 > this.displayWidth || this.img.height + 60 > this.displayHeight) {
                    float ratio = PApplet.parseFloat((int)this.img.width) / PApplet.parseFloat((int)this.img.height);
                    int targetHeight = 0;
                    int targetWidth = 0;
                    if (this.img.width + 60 > this.displayWidth) {
                        targetHeight = PApplet.parseInt((float)(((float)this.displayWidth - 60.0f) / ratio));
                        targetWidth = this.displayWidth - 60;
                    }
                    if (this.img.height + 60 > this.displayHeight) {
                        targetWidth = PApplet.parseInt((float)(((float)this.displayHeight - 60.0f) * ratio));
                        targetHeight = this.displayHeight - 60;
                    }
                    PGraphics scaledImage = this.createGraphics(targetWidth, targetHeight);
                    scaledImage.beginDraw();
                    scaledImage.background(0.0f, 0.0f, 0.0f, 0.0f);
                    scaledImage.image(this.img, 0.0f, 0.0f, (float)targetWidth, (float)targetHeight);
                    scaledImage.endDraw();
                    Scaled = " Original image was too large for your display - scaled to fit";
                    this.img = scaledImage.get(0, 0, targetWidth, targetHeight);
                }
                this.img_b = this.img.get();
                this.img_c = this.countourImage(this.img_b, 1, 80);
                this.surface.setSize(this.img.width, this.img.height);
                this.zoom = 1.0f;
                this.xpt = 0.0f;
                this.ypt = 0.0f;
                this.xzt = 0.0f;
                this.yzt = 0.0f;
                this.userPointsHash = new LinkedHashSet();
                this.points = new LinkedHashSet();
                this.pointsDisplay = new LinkedHashSet();
                this.points.add(new PVector(0.0f, 0.0f, 0.0f));
                this.points.add(new PVector((float)(this.img.width - 1), 0.0f, 0.0f));
                this.points.add(new PVector((float)(this.img.width - 1), (float)(this.img.height - 1), 0.0f));
                this.points.add(new PVector(0.0f, (float)(this.img.height - 1), 0.0f));
                this.points.add(new PVector((float)(this.img.width / 2), (float)(this.img.height / 2), 0.0f));
                this.userPointsHash.addAll(this.points);
                this.pointsDisplay.addAll(this.points);
                this.contourImgPoints = this.getThresholdPixels(this.img_c, true);
                this.nonContourPoints = this.contourImgPoints.get(0);
                this.contourPoints = this.contourImgPoints.get(1);
                this.cWSlider.setValue(1.0f);
                this.cThSlider.setValue(80.0f);
                this.displayType = "mesh";
                this.r.activate(2);
                this.nCPSlider.setValue(0.0f);
                this.cPSlider.setValue(0.0f);
                this.ta.setColor(this.color(0, 255, 0));
                this.ta.setText("Success.\nImage file is loaded." + Scaled);
            } else {
                this.ta.setColor(this.color(255, 0, 0));
                this.ta.setText("Error.\nFile chosen is not a valid image file.");
            }
        } else {
            this.ta.setColor(this.color(255, 0, 0));
            this.ta.setText("Error.\nPlease choose an image file. (JPEG, JPG, PNG, TGA or GIF).");
        }
    }

    public void pointsFileSave(File selection) {
        if (selection == null) {
            this.ta.setColor(this.color(255));
            this.ta.setText("Status.\nNothing selected, no file saved.");
        } else {
            this.output = selection.getName().endsWith(".txt") ? this.createWriter(selection.getAbsolutePath()) : this.createWriter(String.valueOf(selection.getAbsolutePath()) + ".txt");
            this.output.println(String.valueOf(this.img.width) + " " + this.img.height);
            for (PVector temp : this.points) {
                this.output.println(temp);
            }
            this.output.flush();
            this.output.close();
            this.ta.setColor(this.color(0, 255, 0));
            this.ta.setText("Success.\nThe File was Saved Successfully!");
        }
    }

    public void mouseMoved() {
        this.loop();
        this.mappedMouseX = (float)this.mouseX / this.zoom - (this.xpt - this.xzt);
        this.mappedMouseY = (float)this.mouseY / this.zoom - (this.ypt - this.yzt);
        if (!this.deleteMode && !this.panMode) {
            this.pointsDisplay = (LinkedHashSet)this.points.clone();
            this.pointsDisplay.add(new PVector(this.mappedMouseX, this.mappedMouseY, 0.0f));
        } else if (this.deleteMode) {
            // empty if block
        }
    }

    public void mouseDragged() {
        if (this.mouseButton == 3) {
            this.panMode = true;
            this.xpt -= (float)(this.pmouseX - this.mouseX) / this.zoom;
            this.ypt -= (float)(this.pmouseY - this.mouseY) / this.zoom;
        }
    }

    public void mouseWheel(MouseEvent event) {
        this.swt -= (float)event.getCount();
        if (this.swt == 0.0f) {
            this.zoom = 1.0f;
        } else if (this.swt >= 1.0f && this.swt <= 10.0f) {
            this.zoom = TriangulateImage7_2_3_2_1.pow((float)2.0f, (float)this.swt);
        } else if (this.swt <= -1.0f && this.swt >= -10.0f) {
            this.zoom = 1.0f / TriangulateImage7_2_3_2_1.pow((float)2.0f, (float)TriangulateImage7_2_3_2_1.abs((float)this.swt));
        }
        this.xzt = (this.zoom - 1.0f) * (float)this.width / 2.0f / this.zoom;
        this.yzt = (this.zoom - 1.0f) * (float)this.height / 2.0f / this.zoom;
        if (event.getCount() <= -1) {
            this.xpt -= (float)(this.mouseX - this.width / 2) / this.zoom;
            this.ypt -= (float)(this.mouseY - this.height / 2) / this.zoom;
        } else {
            this.xpt += (float)(this.mouseX - this.width / 2) / TriangulateImage7_2_3_2_1.pow((float)2.0f, (float)(this.swt + 1.0f));
            this.ypt += (float)(this.mouseY - this.height / 2) / TriangulateImage7_2_3_2_1.pow((float)2.0f, (float)(this.swt + 1.0f));
        }
    }

    public void mouseEntered() {
    }

    public void mouseExited() {
        this.pointsDisplay = (LinkedHashSet)this.points.clone();
    }

    public void mousePressed() {
        if (this.mouseButton != 3) {
            this.panMode = false;
        }
        if (!this.deleteMode && this.mouseEvent.getClickCount() < 2 && this.mouseButton == 37) {
            this.noLoop();
            this.points.add(new PVector(this.mappedMouseX, this.mappedMouseY, 0.0f));
            this.userPointsHash.add(new PVector(this.mappedMouseX, this.mappedMouseY, 0.0f));
        } else if (this.deleteMode && this.mouseButton == 37) {
            this.refreshBuffer = true;
            this.refreshBufferOnce = true;
            Iterator it = this.pointsDisplay.iterator();
            while (it.hasNext()) {
                PVector p = (PVector)it.next();
                float d = TriangulateImage7_2_3_2_1.dist((float)this.mappedMouseX, (float)this.mappedMouseY, (float)p.x, (float)p.y);
                if (!(d < this.eraserSize)) continue;
                this.userPointsHash.remove(p);
                it.remove();
            }
            this.points = (LinkedHashSet)this.pointsDisplay.clone();
        }
    }

    public void mouseReleased() {
        this.panMode = false;
        this.frameRate(60.0f);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"TriangulateImage7_2_3_2_1"};
        if (passedArgs != null) {
            PApplet.main((String[])TriangulateImage7_2_3_2_1.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    public class ControlFrame
    extends PApplet {
        int w;
        int h;
        String name;
        PApplet parent;
        ControlP5 cp5;

        public ControlFrame(PApplet _parent, int _w, int _h, String _name) {
            this.parent = _parent;
            this.w = _w;
            this.h = _h;
            this.name = _name;
            PApplet.runSketch((String[])new String[]{this.name}, (PApplet)this);
        }

        public void settings() {
            this.size(this.w, this.h);
        }

        public void setup() {
            this.surface.setTitle(this.name);
            this.surface.setLocation(TriangulateImage7_2_3_2_1.this.initWindowLocationX, TriangulateImage7_2_3_2_1.this.initWindowLocationY);
            this.frameRate(25.0f);
            this.cp5 = new ControlP5((PApplet)this);
            int marginX = 10;
            int groupInsetX = 10;
            int groupWidth = TriangulateImage7_2_3_2_1.this.controlFrameWidth - 4 * marginX;
            int[] largeButtonSize = new int[]{groupWidth - 2 * groupInsetX, 20};
            int sliderWidth = 205;
            TriangulateImage7_2_3_2_1.this.chooseButton = (Button)((Button)((Button)((Button)((Button)this.cp5.addButton("choose").setPosition((float)marginX, 20.0f)).setSize(groupWidth, largeButtonSize[1] + 10)).plugTo((Object)this.parent, "choose")).setLabel("Choose an Image...")).linebreak();
            Group g1 = (Group)((Group)((Group)((Group)((Group)this.cp5.addGroup("g1").setPosition((float)marginX, TriangulateImage7_2_3_2_1.this.chooseButton.getPosition()[1] + (float)TriangulateImage7_2_3_2_1.this.chooseButton.getHeight() + 30.0f)).setLabel("Blur Controls")).setBackgroundColor(this.color(0, 60))).setSize(groupWidth, 100)).disableCollapse();
            TriangulateImage7_2_3_2_1.this.blurSlider = (Slider)((Slider)((Slider)((Slider)this.cp5.addSlider("blur").setPosition((float)groupInsetX, 10.0f)).setSize(sliderWidth, largeButtonSize[1]).setRange(0.0f, 20.0f).setValue(5.0f).setLabel("Blur Radius")).plugTo((Object)this.parent, "blur")).setGroup((ControllerGroup)g1);
            TriangulateImage7_2_3_2_1.this.thSlider = (Slider)((Slider)((Slider)((Slider)this.cp5.addSlider("threshold").setPosition((float)groupInsetX, 40.0f)).setSize(sliderWidth, largeButtonSize[1]).setRange(0.0f, 255.0f).setValue(10.0f).setLabel("Threshold")).plugTo((Object)this.parent, "threshold")).setGroup((ControllerGroup)g1);
            TriangulateImage7_2_3_2_1.this.blurButton = (Button)((Button)((Button)((Button)((Button)this.cp5.addButton("blurIt").setPosition((float)groupInsetX, 70.0f)).setSize(sliderWidth, largeButtonSize[1])).plugTo((Object)this.parent, "blurIt")).setLabel("Blur")).setGroup((ControllerGroup)g1);
            Group g2 = (Group)((Group)((Group)((Group)((Group)this.cp5.addGroup("g2").setPosition((float)marginX, g1.getPosition()[1] + (float)g1.getBackgroundHeight() + 30.0f)).setLabel("Point Generation")).setBackgroundColor(this.color(0, 60))).setSize(groupWidth, 130)).disableCollapse();
            TriangulateImage7_2_3_2_1.this.cWSlider = (Slider)((Slider)((Slider)((Slider)this.cp5.addSlider("contWeight").setPosition((float)groupInsetX, 10.0f)).setSize(sliderWidth, largeButtonSize[1]).setRange(0.0f, 25.0f).setValue(1.0f).setLabel("Edge Weight")).plugTo((Object)this.parent, "contWeight")).setGroup((ControllerGroup)g2);
            TriangulateImage7_2_3_2_1.this.cThSlider = (Slider)((Slider)((Slider)((Slider)this.cp5.addSlider("contThreshold").setPosition((float)groupInsetX, 40.0f)).setSize(sliderWidth, largeButtonSize[1]).setRange(0.0f, 254.0f).setValue(80.0f).setLabel("Edge Threshold")).plugTo((Object)this.parent, "contThreshold")).setGroup((ControllerGroup)g2);
            TriangulateImage7_2_3_2_1.this.cPSlider = (Slider)((Slider)((Slider)((Slider)this.cp5.addSlider("contourPointsN").setPosition((float)groupInsetX, 70.0f)).setSize(sliderWidth, largeButtonSize[1]).setRange(0.0f, 500.0f).setValue(0.0f).setLabel("# of Edge Points")).plugTo((Object)this.parent, "contourPointsN")).setGroup((ControllerGroup)g2);
            TriangulateImage7_2_3_2_1.this.nCPSlider = (Slider)((Slider)((Slider)((Slider)this.cp5.addSlider("randomPointsN").setPosition((float)groupInsetX, 100.0f)).setSize(sliderWidth, largeButtonSize[1]).setRange(0.0f, 500.0f).setValue(0.0f).setLabel("# of Random Points")).plugTo((Object)this.parent, "randomPointsN")).setGroup((ControllerGroup)g2);
            Group g3 = (Group)((Group)((Group)((Group)((Group)this.cp5.addGroup("g3").setPosition((float)marginX, g2.getPosition()[1] + (float)g2.getBackgroundHeight() + 30.0f)).setLabel("Point Control")).setBackgroundColor(this.color(0, 60))).setSize(groupWidth, 60)).disableCollapse();
            TriangulateImage7_2_3_2_1.this.sPButton = (Button)((Button)((Button)((Button)((Button)this.cp5.addButton("sPoints").setPosition((float)groupInsetX, (float)groupInsetX)).setSize(90, largeButtonSize[1])).plugTo((Object)this.parent, "sPoints")).setLabel("Save Points")).setGroup((ControllerGroup)g3);
            TriangulateImage7_2_3_2_1.this.lPButton = (Button)((Button)((Button)((Button)((Button)this.cp5.addButton("lPoints").setPosition(TriangulateImage7_2_3_2_1.this.sPButton.getPosition()[0] + (float)TriangulateImage7_2_3_2_1.this.sPButton.getWidth() + 15.0f, (float)groupInsetX)).setSize(90, largeButtonSize[1])).plugTo((Object)this.parent, "lPoints")).setLabel("Load Points")).setGroup((ControllerGroup)g3);
            TriangulateImage7_2_3_2_1.this.e = (Toggle)((Toggle)((Toggle)((Toggle)((Toggle)this.cp5.addToggle("eraser").plugTo((Object)this.parent, "eraser")).setPosition(TriangulateImage7_2_3_2_1.this.lPButton.getPosition()[0] + (float)TriangulateImage7_2_3_2_1.this.lPButton.getWidth() + 15.0f, (float)groupInsetX)).setSize(90, largeButtonSize[1])).setLabel("On/Off Eraser (e)")).setGroup((ControllerGroup)g3);
            Group g4 = (Group)((Group)((Group)((Group)((Group)this.cp5.addGroup("g4").setPosition((float)marginX, g3.getPosition()[1] + (float)g3.getBackgroundHeight() + 30.0f)).setLabel("Display Options")).setBackgroundColor(this.color(0, 60))).setSize(groupWidth, 70)).disableCollapse();
            TriangulateImage7_2_3_2_1.this.r = (RadioButton)((RadioButton)this.cp5.addRadioButton("passChooser").setPosition((float)groupInsetX, 10.0f)).setSize(20, largeButtonSize[1]).setItemsPerRow(3).setSpacingColumn(90).setSpacingRow(10).addItem("original (o)", 1.0f).addItem("blurred (b)", 2.0f).addItem("mesh (m)", 3.0f).addItem("contour (c)", 5.0f).addItem("result (r)", 4.0f).activate(2).plugTo((Object)this.parent, "passChooser").setGroup((ControllerGroup)g4);
            Button sP = (Button)((Button)((Button)((Button)this.cp5.addButton("savePDF").setPosition((float)marginX, g4.getPosition()[1] + (float)g4.getBackgroundHeight() + 10.0f)).setSize(groupWidth, largeButtonSize[1])).setLabel("Write to PDF")).plugTo((Object)this.parent, "savePDF");
            Button sO = (Button)((Button)((Button)((Button)this.cp5.addButton("saveOBJ").setPosition((float)marginX, sP.getPosition()[1] + (float)sP.getHeight() + 10.0f)).setSize(groupWidth, largeButtonSize[1])).setLabel("Write to OBJ")).plugTo((Object)this.parent, "saveOBJ");
            TriangulateImage7_2_3_2_1.this.ta = ((Textarea)this.cp5.addTextarea("txt").setPosition((float)marginX, sO.getPosition()[1] + 30.0f)).setSize(groupWidth, 60).setLineHeight(14).setColor(this.color(255)).setColorBackground(this.color(2, 52, 77)).setBorderColor(this.color(2, 52, 77)).setText("Message Window");
        }

        public void draw() {
            this.background(100);
        }

        public ControlP5 control() {
            return this.cp5;
        }

        public void keyPressed() {
            if (this.key == 's' || this.key == 'S') {
                PGraphics pdf = this.createGraphics(TriangulateImage7_2_3_2_1.this.img.width, TriangulateImage7_2_3_2_1.this.img.height, "processing.pdf.PGraphicsPDF", "output.pdf");
                pdf.beginDraw();
                pdf.noStroke();
                pdf.image(TriangulateImage7_2_3_2_1.this.img, 0.0f, 0.0f);
                LinkedHashSet pointsDisplay = new LinkedHashSet();
                pointsDisplay = (LinkedHashSet)TriangulateImage7_2_3_2_1.this.points.clone();
                TriangulateImage7_2_3_2_1.this.triangles = Triangulate.triangulate(pointsDisplay);
                int i = 0;
                while (i < TriangulateImage7_2_3_2_1.this.triangles.size()) {
                    Triangle t = (Triangle)TriangulateImage7_2_3_2_1.this.triangles.get(i);
                    int ave_x = PApplet.parseInt((float)((t.p1.x + t.p2.x + t.p3.x) / 3.0f));
                    int ave_y = PApplet.parseInt((float)((t.p1.y + t.p2.y + t.p3.y) / 3.0f));
                    pdf.fill(TriangulateImage7_2_3_2_1.this.img_b.get(ave_x, ave_y));
                    pdf.triangle(t.p1.x, t.p1.y, t.p2.x, t.p2.y, t.p3.x, t.p3.y);
                    ++i;
                }
                pdf.dispose();
                pdf.endDraw();
                this.save("output.png");
            }
            if (this.key == 'o' || this.key == 'O') {
                TriangulateImage7_2_3_2_1.this.displayType = "image";
                TriangulateImage7_2_3_2_1.this.r.activate(0);
            }
            if (this.key == 'r' || this.key == 'R') {
                TriangulateImage7_2_3_2_1.this.displayType = "result";
                TriangulateImage7_2_3_2_1.this.r.activate(4);
            }
            if (this.key == 'b' || this.key == 'B') {
                TriangulateImage7_2_3_2_1.this.displayType = "blurred";
                TriangulateImage7_2_3_2_1.this.r.activate(1);
            }
            if (this.key == 'm' || this.key == 'M') {
                TriangulateImage7_2_3_2_1.this.displayType = "mesh";
                TriangulateImage7_2_3_2_1.this.r.activate(2);
            }
            if (this.key == 'c' || this.key == 'C') {
                TriangulateImage7_2_3_2_1.this.displayType = "contour";
                TriangulateImage7_2_3_2_1.this.r.activate(3);
            }
            if (this.key == 'e' || this.key == 'E') {
                if (TriangulateImage7_2_3_2_1.this.deleteMode) {
                    TriangulateImage7_2_3_2_1.this.e.setState(false);
                } else if (!TriangulateImage7_2_3_2_1.this.deleteMode) {
                    TriangulateImage7_2_3_2_1.this.e.setState(true);
                }
            }
            if ((this.key == '}' || this.key == ']') && TriangulateImage7_2_3_2_1.this.eraserSize != (float)TriangulateImage7_2_3_2_1.this.maxEraserSize) {
                TriangulateImage7_2_3_2_1.this.eraserSize += 1.0f;
            }
            if ((this.key == '{' || this.key == '[') && TriangulateImage7_2_3_2_1.this.eraserSize != (float)TriangulateImage7_2_3_2_1.this.minEraserSize) {
                TriangulateImage7_2_3_2_1.this.eraserSize -= 1.0f;
            }
        }
    }
}

