/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import processing.core.PApplet;
import processing.core.PVector;

public class Triangulate {
    private static boolean circumCircle(PVector p, Triangle t, PVector circle) {
        if (PApplet.abs((float)(t.p1.y - t.p2.y)) < 1.0E-4f && PApplet.abs((float)(t.p2.y - t.p3.y)) < 1.0E-4f) {
            System.err.println("CircumCircle: Points are coincident.");
            return false;
        }
        if (PApplet.abs((float)(t.p2.y - t.p1.y)) < 1.0E-4f) {
            float m2 = -(t.p3.x - t.p2.x) / (t.p3.y - t.p2.y);
            float mx2 = (t.p2.x + t.p3.x) / 2.0f;
            float my2 = (t.p2.y + t.p3.y) / 2.0f;
            circle.x = (t.p2.x + t.p1.x) / 2.0f;
            circle.y = m2 * (circle.x - mx2) + my2;
        } else if (PApplet.abs((float)(t.p3.y - t.p2.y)) < 1.0E-4f) {
            float m1 = -(t.p2.x - t.p1.x) / (t.p2.y - t.p1.y);
            float mx1 = (t.p1.x + t.p2.x) / 2.0f;
            float my1 = (t.p1.y + t.p2.y) / 2.0f;
            circle.x = (t.p3.x + t.p2.x) / 2.0f;
            circle.y = m1 * (circle.x - mx1) + my1;
        } else {
            float m1 = -(t.p2.x - t.p1.x) / (t.p2.y - t.p1.y);
            float m2 = -(t.p3.x - t.p2.x) / (t.p3.y - t.p2.y);
            float mx1 = (t.p1.x + t.p2.x) / 2.0f;
            float mx2 = (t.p2.x + t.p3.x) / 2.0f;
            float my1 = (t.p1.y + t.p2.y) / 2.0f;
            float my2 = (t.p2.y + t.p3.y) / 2.0f;
            circle.x = (m1 * mx1 - m2 * mx2 + my2 - my1) / (m1 - m2);
            circle.y = m1 * (circle.x - mx1) + my1;
        }
        float dx = t.p2.x - circle.x;
        float dy = t.p2.y - circle.y;
        float rsqr = dx * dx + dy * dy;
        circle.z = PApplet.sqrt((float)rsqr);
        dx = p.x - circle.x;
        dy = p.y - circle.y;
        float drsqr = dx * dx + dy * dy;
        return drsqr <= rsqr;
    }

    public static ArrayList<Triangle> triangulate(LinkedHashSet<PVector> pxyzIn) {
        TreeSet<PVector> treeListX = new TreeSet<PVector>(new Comparator<PVector>(){

            @Override
            public int compare(PVector p1, PVector p2) {
                if (p1.x < p2.x) {
                    return -1;
                }
                if (p1.x > p2.x) {
                    return 1;
                }
                return (int)(p1.y - p2.y);
            }
        });
        TreeSet<PVector> treeListY = new TreeSet<PVector>(new Comparator<PVector>(){

            @Override
            public int compare(PVector p1, PVector p2) {
                if (p1.y < p2.y) {
                    return -1;
                }
                if (p1.y > p2.y) {
                    return 1;
                }
                return (int)(p1.x - p2.x);
            }
        });
        try {
            treeListX.addAll(pxyzIn);
            treeListY.addAll(treeListX);
        }
        catch (Exception exception) {
            System.out.println("Something went wrong.");
        }
        float xmin = treeListX.first().x;
        float ymin = treeListY.first().y;
        float xmax = treeListX.last().x;
        float ymax = treeListY.last().y;
        float dx = xmax - xmin;
        float dy = ymax - ymin;
        float dmax = dx > dy ? dx : dy;
        float xmid = (xmax + xmin) / 2.0f;
        float ymid = (ymax + ymin) / 2.0f;
        ArrayList<Triangle> triangles = new ArrayList<Triangle>();
        HashSet<Triangle> complete = new HashSet<Triangle>();
        Triangle superTriangle = new Triangle();
        superTriangle.p1 = new PVector(xmid - 2.0f * dmax, ymid - dmax, 0.0f);
        superTriangle.p2 = new PVector(xmid, ymid + 2.0f * dmax, 0.0f);
        superTriangle.p3 = new PVector(xmid + 2.0f * dmax, ymid - dmax, 0.0f);
        triangles.add(superTriangle);
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (PVector p : treeListX) {
            edges.clear();
            PVector circle = new PVector();
            int j = triangles.size() - 1;
            while (j >= 0) {
                Triangle t = triangles.get(j);
                if (!complete.contains(t)) {
                    boolean inside = Triangulate.circumCircle(p, t, circle);
                    if (circle.x + circle.z < p.x) {
                        complete.add(t);
                    }
                    if (inside) {
                        edges.add(new Edge(t.p1, t.p2));
                        edges.add(new Edge(t.p2, t.p3));
                        edges.add(new Edge(t.p3, t.p1));
                        triangles.remove(j);
                    }
                }
                --j;
            }
            j = 0;
            while (j < edges.size() - 1) {
                Edge e1 = (Edge)edges.get(j);
                int k = j + 1;
                while (k < edges.size()) {
                    Edge e2 = (Edge)edges.get(k);
                    if (e1.p1 == e2.p2 && e1.p2 == e2.p1) {
                        e1.p1 = null;
                        e1.p2 = null;
                        e2.p1 = null;
                        e2.p2 = null;
                    }
                    if (e1.p1 == e2.p1 && e1.p2 == e2.p2) {
                        e1.p1 = null;
                        e1.p2 = null;
                        e2.p1 = null;
                        e2.p2 = null;
                    }
                    ++k;
                }
                ++j;
            }
            j = 0;
            while (j < edges.size()) {
                Edge e = (Edge)edges.get(j);
                if (e.p1 != null && e.p2 != null) {
                    triangles.add(new Triangle(e.p1, e.p2, p));
                }
                ++j;
            }
        }
        int i = triangles.size() - 1;
        while (i >= 0) {
            Triangle t = triangles.get(i);
            if (t.sharesVertex(superTriangle)) {
                triangles.remove(i);
            }
            --i;
        }
        return triangles;
    }

    private static class XComparator
    implements Comparator<PVector> {
        private XComparator() {
        }

        @Override
        public int compare(PVector p1, PVector p2) {
            if (p1.x < p2.x) {
                return -1;
            }
            if (p1.x > p2.x) {
                return 1;
            }
            return 0;
        }
    }
}

