/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

public class SmartBlurFilter {
    private double SENSITIVITY = 10.0;
    private int REGION_SIZE = 5;
    float[] kernelArray = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    Kernel kernel = new Kernel(14, 14, this.normalizeKernel(this.kernelArray));

    float[] normalizeKernel(float[] ar) {
        int n = 0;
        int i = 0;
        while (i < ar.length) {
            n = (int)((float)n + ar[i]);
            ++i;
        }
        i = 0;
        while (i < ar.length) {
            int n2 = i++;
            ar[n2] = ar[n2] / (float)n;
        }
        return ar;
    }

    public double lerp(double a, double b, double amt) {
        return a + amt * (b - a);
    }

    public double getLerpAmount(double a, double cutoff) {
        if (a > cutoff) {
            return 1.0;
        }
        return a / cutoff;
    }

    public double rmsError(int[] pixels) {
        double ave = 0.0;
        int i = 0;
        while (i < pixels.length) {
            ave += (double)(pixels[i] >> 8 & 0xFF);
            ++i;
        }
        ave /= (double)pixels.length;
        double diff = 0.0;
        double accumulator = 0.0;
        int i2 = 0;
        while (i2 < pixels.length) {
            diff = (double)(pixels[i2] >> 8 & 0xFF) - ave;
            diff *= diff;
            accumulator += diff;
            ++i2;
        }
        double rms = accumulator / (double)pixels.length;
        rms = Math.sqrt(rms);
        return rms;
    }

    int[] getSample(BufferedImage image, int x, int y, int size) {
        int[] pixels = new int[]{};
        try {
            BufferedImage subimage = image.getSubimage(x, y, size, size);
            pixels = subimage.getRGB(0, 0, size, size, null, 0, size);
        }
        catch (Exception exception) {}
        return pixels;
    }

    int lerpPixel(int oldpixel, int newpixel, double amt) {
        int oldRed = oldpixel >> 16 & 0xFF;
        int newRed = newpixel >> 16 & 0xFF;
        int red = (int)this.lerp(oldRed, newRed, amt) & 0xFF;
        int oldGreen = oldpixel >> 8 & 0xFF;
        int newGreen = newpixel >> 8 & 0xFF;
        int green = (int)this.lerp(oldGreen, newGreen, amt) & 0xFF;
        int oldBlue = oldpixel & 0xFF;
        int newBlue = newpixel & 0xFF;
        int blue = (int)this.lerp(oldBlue, newBlue, amt) & 0xFF;
        return red << 16 | green << 8 | blue;
    }

    int[] blurImage(BufferedImage image, int[] orig, int[] blur, double sensitivity) {
        int newPixel = 0;
        double amt = 0.0;
        int size = this.REGION_SIZE;
        int i = 0;
        while (i < orig.length) {
            int w = image.getWidth();
            int[] pix = this.getSample(image, i % w, i / w, size);
            if (pix.length != 0) {
                amt = this.getLerpAmount(this.rmsError(pix), sensitivity);
                orig[i] = newPixel = this.lerpPixel(blur[i], orig[i], amt);
            }
            ++i;
        }
        return orig;
    }

    public BufferedImage filter(BufferedImage image) {
        ConvolveOp convolver = new ConvolveOp(this.kernel, 1, null);
        BufferedImage target = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        Graphics2D g = target.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        int w = target.getWidth();
        int h = target.getHeight();
        int[] pixels = image.getRGB(0, 0, w, h, null, 0, w);
        target = convolver.filter(target, image);
        int[] blurryPixels = target.getRGB(0, 0, w, h, null, 0, w);
        pixels = this.blurImage(image, pixels, blurryPixels, this.SENSITIVITY);
        image.setRGB(0, 0, w, h, pixels, 0, w);
        return image;
    }

    public void setRadius(int vRadius) {
        this.REGION_SIZE = vRadius;
    }

    public void setThreshold(double threshold) {
        this.SENSITIVITY = threshold;
    }

    public int getRadius() {
        return this.REGION_SIZE;
    }

    public double getThreshold() {
        return this.SENSITIVITY;
    }
}

